"""
base class for all policies
"""
from abc import ABC
from policies.utils.episode_memory import EpisodeMemory

class BasePolicy(ABC):
    def __init__(self, agent_id):
        self.agent_id = agent_id
        self.step_count = 0
        self.episode_return = 0
        self.skip_frames = 0
        self.replay_buffer = None
        self.is_focal = False

    def reset(self):
        self.episode_return = 0

    def observe(self, obs, reward, terminated, truncated, info):
        self.episode_return += reward

    def act(self):
        raise NotImplementedError

    def get_episode_return(self):
        return self.episode_return

    def store_transition(self, transition):
        pass

    def learn(self):
        pass

    def save(self, ckpt_num):
        pass

    def load(self, ckpt_num):
        pass